# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from enum import Enum
from .sdtype import *
from .sdarray import *
from .sdproperty import *
from .sdvalue import *
from .sdmetadatadict import *
from .sdapiobject import *
from .sdpackage import *
from .sdtype import *
from .sdproperty import *
from .sdproperty import *
from .sdapiobject import *
from .apiexception import APIException

class EmbedMethod(Enum):
    """
    Enum representing the embedding method for resources when using external assets
    """
    Undefined = 0
    """The resource references its original file"""
    Linked = 1
    """The original file is copied to another location, and the resource references the copy."""
    CopiedAndLinked = 2
    """The file content is encoded directly in the resource (in memory at runtime, and in the Package file content). No file is referenced."""
    BinaryEmbedded = 3

class SDResource(SDAPIObject):
    """
    Class managing any element that can be part of a SDPackage (Graph, Bitmap, Folder, ...)
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDResource
        """
        super(SDResource, self).__init__(APIContext, handle, *args, **kwargs)

    def getType(self) -> Optional[SDType]:
        """
        Get the resource type as SDType

        """
        outType = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getType(self.mHandle, ctypes.byref(outType))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outType, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outType.value, ownHandle=True)

    def getIdentifier(self) -> str:
        """
        Get the resource identifier as string

        """
        outIdentifier = ctypes.c_char_p()
        _res = self.mAPIContext.SDResource_getIdentifier(self.mHandle, ctypes.byref(outIdentifier))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outIdentifier.value.decode('utf-8') # type: ignore

    def setIdentifier(self, identifier : str) -> None:
        """
        Set the resource identifier

        :param identifier: The new resource identifier
        """
        _res = self.mAPIContext.SDResource_setIdentifier(self.mHandle, ctypes.create_string_buffer(identifier.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getUrl(self) -> str:
        """
        Retrieve the resource URL

        """
        outUrl = ctypes.c_char_p()
        _res = self.mAPIContext.SDResource_getUrl(self.mHandle, ctypes.byref(outUrl))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outUrl.value.decode('utf-8') # type: ignore

    def getFilePath(self) -> str:
        """
        Get the path of the file used by this resource

        """
        outPath = ctypes.c_char_p()
        _res = self.mAPIContext.SDResource_getFilePath(self.mHandle, ctypes.byref(outPath))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPath.value.decode('utf-8') # type: ignore

    def getEmbedMethod(self) -> EmbedMethod:
        """
        Get the method used by this resource to reference its content or file (See EmbedMethod enum)

        """
        outEmbedMethod = ctypes.c_int()
        _res = self.mAPIContext.SDResource_getEmbedMethod(self.mHandle, ctypes.byref(outEmbedMethod))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return EmbedMethod(outEmbedMethod.value)

    def getProperties(self, sdPropertyCategory : SDPropertyCategory) -> SDArray[SDProperty]:
        """
        Get all properties of the specified category (Input, Output or Annotation)

        :param sdPropertyCategory: The enum value the indicate which type of properties to get
        """
        outSDPropertyArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getProperties(self.mHandle, sdPropertyCategory.value, ctypes.byref(outSDPropertyArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPropertyArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPropertyArray.value, ownHandle=True)

    def getPropertyFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDProperty]:
        """
        Get property that match the specified identifier in the specified category

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def getPropertyValue(self, sdProperty : SDProperty) -> Optional[SDValue]:
        """
        Get the value of a property

        :param sdProperty: The property we want to retrieve the value from
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyValue(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyValue(self, sdProperty : SDProperty, sdValue : SDValue) -> None:
        """
        Set the value of the specified property

        :param sdProperty: The property we want to retrieve the value from
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDResource_setPropertyValue(self.mHandle, sdProperty.mHandle, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setInputPropertyValueFromId(self, sdInputPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the specified input property retrieved by his identifier

        :param sdInputPropertyId: The identifier of the input property
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDResource_setInputPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdInputPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setAnnotationPropertyValueFromId(self, sdAnnotationPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the specified annotation property retrieved by his identifier

        :param sdAnnotationPropertyId: The identifier of the annotation property
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDResource_setAnnotationPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdAnnotationPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyValueFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDValue]:
        """
        Get the value of the property that matches the specified identifier in the specified category

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def getInputPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the input property that matches the specified identifier

        :param sdPropertyId: The identifier of the input property we want to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getInputPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def getAnnotationPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the annotation property that matches the specified identifier

        :param sdPropertyId: The identifier of the annotation property we want to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getAnnotationPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def getPropertyAnnotations(self, sdProperty : SDProperty) -> SDArray[SDProperty]:
        """
        Get the annotation properties of the specified property

        :param sdProperty: The SDProperty to retrieve the annotations from
        """
        outSDPropertyArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyAnnotations(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDPropertyArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPropertyArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPropertyArray.value, ownHandle=True)

    def getPropertyAnnotationValueFromId(self, sdProperty : SDProperty, sdPropertyAnnotationId : str) -> Optional[SDValue]:
        """
        Get the property annotation value of the specified property

        :param sdProperty: The property we want to retrieve the annotation value from
        :param sdPropertyAnnotationId: The identifier of the annotation to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyAnnotationValueFromId(self.mHandle, sdProperty.mHandle, ctypes.create_string_buffer(sdPropertyAnnotationId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyAnnotationValueFromId(self, sdProperty : SDProperty, sdPropertyAnnotationId : str, sdValue : SDValue) -> None:
        """
        Set the property annotation value of the specified property

        :param sdProperty: The property whose we want to change the annotation value
        :param sdPropertyAnnotationId: The identifier of the annotation to set
        :param sdValue: The SDValue to set
        """
        _res = self.mAPIContext.SDResource_setPropertyAnnotationValueFromId(self.mHandle, sdProperty.mHandle, ctypes.create_string_buffer(sdPropertyAnnotationId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyMetadataDictFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDMetadataDict]:
        """
        Get the metadata of the property that matches the specified identifier in the specified category as a SDMetadataDict.

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDMetadataDict = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPropertyMetadataDictFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDMetadataDict))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDMetadataDict, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDMetadataDict.value, ownHandle=True)

    def newProperty(self, sdPropertyId : str, sdPropertyType : SDType, sdPropertyCategory : SDPropertyCategory) -> Optional[SDProperty]:
        """
        Create a new SDProperty of the specified type and in the specified SDPropertyCategory

        :param sdPropertyId: The identifier of the new property
        :param sdPropertyType: The type of the new property
        :param sdPropertyCategory: The SDPropertyCategory of the new property to create
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_newProperty(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyType.mHandle, sdPropertyCategory.value, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def deleteProperty(self, sdProperty : SDProperty) -> None:
        """
        Delete the specified SDProperty

        :param sdProperty: The property to delete
        """
        _res = self.mAPIContext.SDResource_deleteProperty(self.mHandle, sdProperty.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    @staticmethod
    def sNewFromFile(parent : SDAPIObject, filePath : str, embedMethod : EmbedMethod) -> SDResource:
        """
        Create a new SDResource from the specified file. The resource may reference or copy the file content depending on the EmbedMethod

        :param parent: The parent data that will contains the newly created resource. Can be SDPackage or SDResourceFolder
        :param filePath: The file path
        :param embedMethod: The embed method
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResource_sNewFromFile(parent.mHandle, ctypes.create_string_buffer(filePath.encode('utf-8')), embedMethod.value, ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

    def getPackage(self) -> SDPackage:
        """
        Get the SDPackage the current SDResource belongs to.

        """
        outSDPackage = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getPackage(self.mHandle, ctypes.byref(outSDPackage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPackage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPackage.value, ownHandle=True)

    def getMetadataDict(self) -> Optional[SDMetadataDict]:
        """
        Get the metadata of this resource as a SDMetadataDict.

        """
        outSDMetadataDict = ctypes.c_void_p()
        _res = self.mAPIContext.SDResource_getMetadataDict(self.mHandle, ctypes.byref(outSDMetadataDict))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDMetadataDict, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDMetadataDict.value, ownHandle=True)

    def delete(self) -> None:
        """
        Delete the SDResource.

        """
        _res = self.mAPIContext.SDResource_delete(self.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

